package server;

import static org.easymock.EasyMock.*;
import java.util.*;

import common.IDatabase;
import junit.framework.TestCase;

public class ModelTest extends TestCase {

	private Model model;
	private IDatabase database;

	@Override
	protected void setUp() throws Exception {
		database = createStrictMock(IDatabase.class);
		expect(database.getData()).andReturn(new String[] {"valueA", "valueB"}).anyTimes();
		replay(database);

		model = new Model(database);
	}

	@Override
	protected void tearDown() throws Exception {
		verify(database);
	}

	public void testAOnly() {

		List<String> searchResults = model.performSearch("A");

		assertEquals(Arrays.asList("valueA"), searchResults);
	}

	public void testBOnly() {

		List<String> searchResults = model.performSearch("B");

		assertEquals(Arrays.asList("valueB"), searchResults);
	}

	public void testBadSearch() {

		String badSearchValue = "X";
		List<String> searchResults = model.performSearch(badSearchValue);

		assertEquals(Collections.EMPTY_LIST, searchResults);
	}

	public void testAll() {
		String noSearchRestriction = "";

		List<String> searchResults = model.performSearch(noSearchRestriction);

		assertEquals(Arrays.asList("valueA", "valueB"), searchResults);
	}
}
